/*

This sample project illustrates how to use the PDF Creator .NET Library 

You can download a fully functional evaluation version from the link below.
http://www.amyuni.com/en/developer/pdfcreator

*/


using System;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.IO;
using Amyuni.PDFCreator;
using System.Text;

namespace PDF_Creator_lib
{
    /// <summary>
    /// Summary description for Form1.
    /// </summary>
    public class Form1 : Form
    {
        private const string StrLicenseTo = "Amyuni Technologies Evaluation";
        private const string StrActivationCode = "07EFCDAB01000100DF3C224FBB4BFE934F6EBA2A0373BD6FA5383C825560ED67F2C03F96E7874560CDBD4825B29C4144E6BC2155FE63";


        private Button _btnEmbedImage;
        private Button _btnAddText;
        private Button _btnAppendDocs;
        private Button _btnMerge;
        private Button _btnExportToJpeg;
        private Button _btnBookmarks;
        private Button _btnNewDoc;
        private Button _btnDigitalSignature;
        private Button _btnPrint;
        private Button _cmdPrintDoc;
        private Button _cmdGetObjectXy;
        private TabControl _tabControl1;
        private TabPage _tabPage1;
        private Button _btnCreateTextObject;
        private TabPage _tabPage2;
        private TabPage _tabPage3;
        private TabPage _tabPage4;
        private ListBox _listBox1;
        private Button _btnExportToXps;
        private Button _btnLoopObjects;
        private Button _btnSearch;
        private Button _btnAddMetaData;
        private Button _btnMetaData2;
        private Button _btnMetaData3;
        private Button _btnEncryption;
        private Button _btnTiff;
        private Button _btnPdFtoHtml;
        private Button _btnXps2Pdf;
        private Button _btnGetObjRect;
        /// <summary>
        /// Required designer variable.
        /// </summary>
        private Container _components = null;

        public Form1()
        {
            //
            // Required for Windows Form Designer support
            //
            InitializeComponent();

            //
            // TODO: Add any constructor code after InitializeComponent call
            //
        }

        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (_components != null)
                {
                    _components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        #region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
        {
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(Form1));
            this._btnEmbedImage = new System.Windows.Forms.Button();
            this._btnAddText = new System.Windows.Forms.Button();
            this._btnAppendDocs = new System.Windows.Forms.Button();
            this._btnMerge = new System.Windows.Forms.Button();
            this._btnExportToJpeg = new System.Windows.Forms.Button();
            this._btnBookmarks = new System.Windows.Forms.Button();
            this._btnNewDoc = new System.Windows.Forms.Button();
            this._btnDigitalSignature = new System.Windows.Forms.Button();
            this._btnPrint = new System.Windows.Forms.Button();
            this._cmdPrintDoc = new System.Windows.Forms.Button();
            this._cmdGetObjectXy = new System.Windows.Forms.Button();
            this._tabControl1 = new System.Windows.Forms.TabControl();
            this._tabPage1 = new System.Windows.Forms.TabPage();
            this._btnGetObjRect = new System.Windows.Forms.Button();
            this._btnMetaData3 = new System.Windows.Forms.Button();
            this._btnMetaData2 = new System.Windows.Forms.Button();
            this._btnAddMetaData = new System.Windows.Forms.Button();
            this._btnSearch = new System.Windows.Forms.Button();
            this._btnLoopObjects = new System.Windows.Forms.Button();
            this._btnCreateTextObject = new System.Windows.Forms.Button();
            this._tabPage2 = new System.Windows.Forms.TabPage();
            this._tabPage3 = new System.Windows.Forms.TabPage();
            this._btnPdFtoHtml = new System.Windows.Forms.Button();
            this._btnXps2Pdf = new System.Windows.Forms.Button();
            this._btnTiff = new System.Windows.Forms.Button();
            this._btnExportToXps = new System.Windows.Forms.Button();
            this._tabPage4 = new System.Windows.Forms.TabPage();
            this._btnEncryption = new System.Windows.Forms.Button();
            this._listBox1 = new System.Windows.Forms.ListBox();
            this._tabControl1.SuspendLayout();
            this._tabPage1.SuspendLayout();
            this._tabPage2.SuspendLayout();
            this._tabPage3.SuspendLayout();
            this._tabPage4.SuspendLayout();
            this.SuspendLayout();
            // 
            // btnEmbedImage
            // 
            this._btnEmbedImage.Location = new System.Drawing.Point(31, 137);
            this._btnEmbedImage.Name = "_btnEmbedImage";
            this._btnEmbedImage.Size = new System.Drawing.Size(160, 28);
            this._btnEmbedImage.TabIndex = 0;
            this._btnEmbedImage.Text = "Embed Image";
            this._btnEmbedImage.Click += new System.EventHandler(this.btnEmbedImage_Click);
            // 
            // btnAddText
            // 
            this._btnAddText.Location = new System.Drawing.Point(31, 68);
            this._btnAddText.Name = "_btnAddText";
            this._btnAddText.Size = new System.Drawing.Size(160, 28);
            this._btnAddText.TabIndex = 1;
            this._btnAddText.Text = "Add text";
            this._btnAddText.Click += new System.EventHandler(this.btnAddText_Click);
            // 
            // btnAppendDocs
            // 
            this._btnAppendDocs.Location = new System.Drawing.Point(24, 55);
            this._btnAppendDocs.Name = "_btnAppendDocs";
            this._btnAppendDocs.Size = new System.Drawing.Size(125, 28);
            this._btnAppendDocs.TabIndex = 2;
            this._btnAppendDocs.Text = "Append Docs";
            this._btnAppendDocs.Click += new System.EventHandler(this.btnAppendDocs_Click);
            // 
            // btnMerge
            // 
            this._btnMerge.Location = new System.Drawing.Point(24, 21);
            this._btnMerge.Name = "_btnMerge";
            this._btnMerge.Size = new System.Drawing.Size(125, 27);
            this._btnMerge.TabIndex = 3;
            this._btnMerge.Text = "Merge Docs";
            this._btnMerge.Click += new System.EventHandler(this.btnMerge_Click);
            // 
            // btnExportToJpeg
            // 
            this._btnExportToJpeg.Location = new System.Drawing.Point(26, 18);
            this._btnExportToJpeg.Name = "_btnExportToJpeg";
            this._btnExportToJpeg.Size = new System.Drawing.Size(180, 28);
            this._btnExportToJpeg.TabIndex = 4;
            this._btnExportToJpeg.Text = "Export to Jpeg";
            this._btnExportToJpeg.Click += new System.EventHandler(this.btnExportToJpeg_Click);
            // 
            // btnBookmarks
            // 
            this._btnBookmarks.Location = new System.Drawing.Point(170, 21);
            this._btnBookmarks.Name = "_btnBookmarks";
            this._btnBookmarks.Size = new System.Drawing.Size(125, 27);
            this._btnBookmarks.TabIndex = 5;
            this._btnBookmarks.Text = "Bookmarks";
            this._btnBookmarks.Click += new System.EventHandler(this.btnBookmarks_Click);
            // 
            // btnNewDoc
            // 
            this._btnNewDoc.Location = new System.Drawing.Point(24, 125);
            this._btnNewDoc.Name = "_btnNewDoc";
            this._btnNewDoc.Size = new System.Drawing.Size(125, 27);
            this._btnNewDoc.TabIndex = 6;
            this._btnNewDoc.Text = "Create New Doc";
            this._btnNewDoc.Click += new System.EventHandler(this.btnNewDoc_Click);
            // 
            // btnDigitalSignature
            // 
            this._btnDigitalSignature.Location = new System.Drawing.Point(24, 90);
            this._btnDigitalSignature.Name = "_btnDigitalSignature";
            this._btnDigitalSignature.Size = new System.Drawing.Size(125, 28);
            this._btnDigitalSignature.TabIndex = 7;
            this._btnDigitalSignature.Text = "Digital Signature";
            this._btnDigitalSignature.Click += new System.EventHandler(this.btnDigitalSignature_Click);
            // 
            // btnPrint
            // 
            this._btnPrint.Location = new System.Drawing.Point(20, 18);
            this._btnPrint.Name = "_btnPrint";
            this._btnPrint.Size = new System.Drawing.Size(170, 28);
            this._btnPrint.TabIndex = 10;
            this._btnPrint.Text = "Print";
            this._btnPrint.Click += new System.EventHandler(this.btnPrint_Click);
            // 
            // cmdPrintDoc
            // 
            this._cmdPrintDoc.Location = new System.Drawing.Point(20, 65);
            this._cmdPrintDoc.Name = "_cmdPrintDoc";
            this._cmdPrintDoc.Size = new System.Drawing.Size(170, 26);
            this._cmdPrintDoc.TabIndex = 11;
            this._cmdPrintDoc.Text = "Print Document";
            this._cmdPrintDoc.UseVisualStyleBackColor = true;
            this._cmdPrintDoc.Click += new System.EventHandler(this.cmdPrintDoc_Click);
            // 
            // cmdGetObjectXY
            // 
            this._cmdGetObjectXy.Location = new System.Drawing.Point(31, 103);
            this._cmdGetObjectXy.Name = "_cmdGetObjectXy";
            this._cmdGetObjectXy.Size = new System.Drawing.Size(160, 27);
            this._cmdGetObjectXy.TabIndex = 12;
            this._cmdGetObjectXy.Text = "GetObjectXy";
            this._cmdGetObjectXy.Click += new System.EventHandler(this.cmdGetObjectXY_Click);
            // 
            // tabControl1
            // 
            this._tabControl1.Controls.Add(this._tabPage1);
            this._tabControl1.Controls.Add(this._tabPage2);
            this._tabControl1.Controls.Add(this._tabPage3);
            this._tabControl1.Controls.Add(this._tabPage4);
            this._tabControl1.Location = new System.Drawing.Point(34, 29);
            this._tabControl1.Name = "_tabControl1";
            this._tabControl1.SelectedIndex = 0;
            this._tabControl1.Size = new System.Drawing.Size(571, 295);
            this._tabControl1.TabIndex = 13;
            // 
            // tabPage1
            // 
            this._tabPage1.Controls.Add(this._btnGetObjRect);
            this._tabPage1.Controls.Add(this._btnMetaData3);
            this._tabPage1.Controls.Add(this._btnMetaData2);
            this._tabPage1.Controls.Add(this._btnAddMetaData);
            this._tabPage1.Controls.Add(this._btnSearch);
            this._tabPage1.Controls.Add(this._btnLoopObjects);
            this._tabPage1.Controls.Add(this._btnCreateTextObject);
            this._tabPage1.Controls.Add(this._btnAddText);
            this._tabPage1.Controls.Add(this._cmdGetObjectXy);
            this._tabPage1.Controls.Add(this._btnEmbedImage);
            this._tabPage1.Location = new System.Drawing.Point(4, 25);
            this._tabPage1.Name = "_tabPage1";
            this._tabPage1.Padding = new System.Windows.Forms.Padding(3);
            this._tabPage1.Size = new System.Drawing.Size(563, 266);
            this._tabPage1.TabIndex = 0;
            this._tabPage1.Text = "Create Objects";
            this._tabPage1.UseVisualStyleBackColor = true;
            // 
            // btnGetObjRect
            // 
            this._btnGetObjRect.Location = new System.Drawing.Point(31, 172);
            this._btnGetObjRect.Name = "_btnGetObjRect";
            this._btnGetObjRect.Size = new System.Drawing.Size(160, 28);
            this._btnGetObjRect.TabIndex = 21;
            this._btnGetObjRect.Text = "GetObj Rect.";
            this._btnGetObjRect.Click += new System.EventHandler(this.btnGetObjRect_Click);
            // 
            // btnMetaData3
            // 
            this._btnMetaData3.Location = new System.Drawing.Point(392, 104);
            this._btnMetaData3.Name = "_btnMetaData3";
            this._btnMetaData3.Size = new System.Drawing.Size(160, 26);
            this._btnMetaData3.TabIndex = 18;
            this._btnMetaData3.Text = "Read MetaData #3";
            this._btnMetaData3.UseVisualStyleBackColor = true;
            this._btnMetaData3.Click += new System.EventHandler(this.btnMetaData3_Click);
            // 
            // btnMetaData2
            // 
            this._btnMetaData2.Location = new System.Drawing.Point(392, 70);
            this._btnMetaData2.Name = "_btnMetaData2";
            this._btnMetaData2.Size = new System.Drawing.Size(160, 26);
            this._btnMetaData2.TabIndex = 17;
            this._btnMetaData2.Text = "MetaData #2";
            this._btnMetaData2.UseVisualStyleBackColor = true;
            this._btnMetaData2.Click += new System.EventHandler(this.btnMetaData2_Click);
            // 
            // btnAddMetaData
            // 
            this._btnAddMetaData.Location = new System.Drawing.Point(392, 33);
            this._btnAddMetaData.Name = "_btnAddMetaData";
            this._btnAddMetaData.Size = new System.Drawing.Size(160, 28);
            this._btnAddMetaData.TabIndex = 16;
            this._btnAddMetaData.Text = "Add Metadata";
            this._btnAddMetaData.Click += new System.EventHandler(this.btnAddMetaData_Click);
            // 
            // btnSearch
            // 
            this._btnSearch.Location = new System.Drawing.Point(216, 68);
            this._btnSearch.Name = "_btnSearch";
            this._btnSearch.Size = new System.Drawing.Size(160, 28);
            this._btnSearch.TabIndex = 15;
            this._btnSearch.Text = "Search Text";
            this._btnSearch.Click += new System.EventHandler(this.btnSearch_Click);
            // 
            // btnLoopObjects
            // 
            this._btnLoopObjects.Location = new System.Drawing.Point(216, 32);
            this._btnLoopObjects.Name = "_btnLoopObjects";
            this._btnLoopObjects.Size = new System.Drawing.Size(160, 29);
            this._btnLoopObjects.TabIndex = 13;
            this._btnLoopObjects.Text = "Loop Objects";
            this._btnLoopObjects.UseVisualStyleBackColor = true;
            this._btnLoopObjects.Click += new System.EventHandler(this.btnLoopObjects_Click);
            // 
            // btnCreateTextObject
            // 
            this._btnCreateTextObject.Location = new System.Drawing.Point(31, 32);
            this._btnCreateTextObject.Name = "_btnCreateTextObject";
            this._btnCreateTextObject.Size = new System.Drawing.Size(160, 29);
            this._btnCreateTextObject.TabIndex = 0;
            this._btnCreateTextObject.Text = "Create Text Object";
            this._btnCreateTextObject.UseVisualStyleBackColor = true;
            this._btnCreateTextObject.Click += new System.EventHandler(this.btnCreateTextObject_Click);
            // 
            // tabPage2
            // 
            this._tabPage2.Controls.Add(this._btnPrint);
            this._tabPage2.Controls.Add(this._cmdPrintDoc);
            this._tabPage2.Location = new System.Drawing.Point(4, 25);
            this._tabPage2.Name = "_tabPage2";
            this._tabPage2.Padding = new System.Windows.Forms.Padding(3);
            this._tabPage2.Size = new System.Drawing.Size(563, 266);
            this._tabPage2.TabIndex = 1;
            this._tabPage2.Text = "Print";
            this._tabPage2.UseVisualStyleBackColor = true;
            // 
            // tabPage3
            // 
            this._tabPage3.Controls.Add(this._btnPdFtoHtml);
            this._tabPage3.Controls.Add(this._btnXps2Pdf);
            this._tabPage3.Controls.Add(this._btnTiff);
            this._tabPage3.Controls.Add(this._btnExportToXps);
            this._tabPage3.Controls.Add(this._btnExportToJpeg);
            this._tabPage3.Location = new System.Drawing.Point(4, 25);
            this._tabPage3.Name = "_tabPage3";
            this._tabPage3.Size = new System.Drawing.Size(563, 266);
            this._tabPage3.TabIndex = 2;
            this._tabPage3.Text = "Export";
            this._tabPage3.UseVisualStyleBackColor = true;
            // 
            // btnPDFtoHTML
            // 
            this._btnPdFtoHtml.Location = new System.Drawing.Point(26, 123);
            this._btnPdFtoHtml.Name = "_btnPdFtoHtml";
            this._btnPdFtoHtml.Size = new System.Drawing.Size(180, 27);
            this._btnPdFtoHtml.TabIndex = 9;
            this._btnPdFtoHtml.Text = "PDF to HTML";
            this._btnPdFtoHtml.UseVisualStyleBackColor = true;
            this._btnPdFtoHtml.Click += new System.EventHandler(this.btnPDFtoHTML_Click);
            // 
            // btnXps2PDF
            // 
            this._btnXps2Pdf.Location = new System.Drawing.Point(26, 157);
            this._btnXps2Pdf.Name = "_btnXps2Pdf";
            this._btnXps2Pdf.Size = new System.Drawing.Size(180, 26);
            this._btnXps2Pdf.TabIndex = 8;
            this._btnXps2Pdf.Text = "XPS to PDF";
            this._btnXps2Pdf.UseVisualStyleBackColor = true;
            this._btnXps2Pdf.Click += new System.EventHandler(this.btnXps2PDF_Click);
            // 
            // btnTiff
            // 
            this._btnTiff.Location = new System.Drawing.Point(26, 89);
            this._btnTiff.Name = "_btnTiff";
            this._btnTiff.Size = new System.Drawing.Size(180, 28);
            this._btnTiff.TabIndex = 7;
            this._btnTiff.Text = "Export to Tiff";
            this._btnTiff.Click += new System.EventHandler(this.btnTiff_Click);
            // 
            // btnExportToXps
            // 
            this._btnExportToXps.Location = new System.Drawing.Point(26, 54);
            this._btnExportToXps.Name = "_btnExportToXps";
            this._btnExportToXps.Size = new System.Drawing.Size(180, 28);
            this._btnExportToXps.TabIndex = 6;
            this._btnExportToXps.Text = "Export to XPS";
            this._btnExportToXps.Click += new System.EventHandler(this.btnExportToXps_Click);
            // 
            // tabPage4
            // 
            this._tabPage4.Controls.Add(this._btnEncryption);
            this._tabPage4.Controls.Add(this._btnMerge);
            this._tabPage4.Controls.Add(this._btnAppendDocs);
            this._tabPage4.Controls.Add(this._btnDigitalSignature);
            this._tabPage4.Controls.Add(this._btnBookmarks);
            this._tabPage4.Controls.Add(this._btnNewDoc);
            this._tabPage4.Location = new System.Drawing.Point(4, 25);
            this._tabPage4.Name = "_tabPage4";
            this._tabPage4.Size = new System.Drawing.Size(563, 266);
            this._tabPage4.TabIndex = 3;
            this._tabPage4.Text = "Documents";
            this._tabPage4.UseVisualStyleBackColor = true;
            // 
            // btnEncryption
            // 
            this._btnEncryption.Location = new System.Drawing.Point(170, 55);
            this._btnEncryption.Name = "_btnEncryption";
            this._btnEncryption.Size = new System.Drawing.Size(125, 28);
            this._btnEncryption.TabIndex = 10;
            this._btnEncryption.Text = "Encryption";
            this._btnEncryption.Click += new System.EventHandler(this.btnEncryption_Click);
            // 
            // listBox1
            // 
            this._listBox1.FormattingEnabled = true;
            this._listBox1.ItemHeight = 16;
            this._listBox1.Location = new System.Drawing.Point(628, 29);
            this._listBox1.Name = "_listBox1";
            this._listBox1.Size = new System.Drawing.Size(438, 276);
            this._listBox1.TabIndex = 15;
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(6, 15);
            this.ClientSize = new System.Drawing.Size(1092, 333);
            this.Controls.Add(this._listBox1);
            this.Controls.Add(this._tabControl1);
            this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
            this.Name = "Form1";
            this.Text = "Amyuni PDF Creator .Net Library";
            this.Load += new System.EventHandler(this.Form1_Load);
            this._tabControl1.ResumeLayout(false);
            this._tabPage1.ResumeLayout(false);
            this._tabPage2.ResumeLayout(false);
            this._tabPage3.ResumeLayout(false);
            this._tabPage4.ResumeLayout(false);
            this.ResumeLayout(false);

        }
        #endregion

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        private static void Main()
        {
            Application.Run(new Form1());
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            //initailize library
            //This should be done once
            //acPDFCreatorLib.Initialize();

        }

        /// <summary>
        /// This code snippet illustrates how to insert an image object into a PDF document 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnEmbedImage_Click(object sender, EventArgs e)
        {
            //initailize library
            //This should be done once
            acPDFCreatorLib.Initialize();

            //set license key 
            acPDFCreatorLib.SetLicenseKey(StrLicenseTo, StrActivationCode);

            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    System.Reflection.Assembly.GetExecutingAssembly().Location))));

            //need to create a document object
            using (IacDocument doc = new IacDocument(null))
            {

                //put component in design mode
                doc.ReportState = IacReportState.acReportStateDesign;

                //create object on Page 1
                using (IacObject oTypePicture = doc.GetPage(1).CreateObject(IacObjectType.acObjectTypePicture, "acObjectTypePicture"))
                {
                    oTypePicture.AttributeByName("Left").Value = 2000;
                    oTypePicture.AttributeByName("Top").Value = 2000;
                    oTypePicture.AttributeByName("Right").Value = doc.GetPage(1).Attribute("Width").Value;
                    oTypePicture.AttributeByName("Bottom").Value = doc.GetPage(1).Attribute("Length").Value;
                    oTypePicture.AttributeByName("FileName").Value = requiredPath + "Source_Docs\\benchmark_chart.jpg";

                }

                //need to open a file stream to save new PDF document
                using (FileStream fs = new FileStream(requiredPath + "\\Resulting_Docs\\EmbedImage_resulting.pdf",
                                                                      FileMode.Create, FileAccess.Write, FileShare.Write))
                {
                    doc.Save(fs, IacFileSaveOption.acFileSaveView);
                    fs.Close();
                }


            }
            //end and cleanup
            //this should only be done once
            acPDFCreatorLib.Terminate();
            _listBox1.Items.Add("EmbedImage_resulting.pdf  .......   created");

        }



        /// <summary>
        /// This code snippet illustrates how enumerate through a document and change the attributes of an acObjectTypeText object
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnAddText_Click(object sender, EventArgs e)
        {
            //initailize library
            //This should be done once
            acPDFCreatorLib.Initialize();

            //set license key 
            acPDFCreatorLib.SetLicenseKey(StrLicenseTo, StrActivationCode);

            // Open the PDF document file.
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    System.Reflection.Assembly.GetExecutingAssembly().Location))));

            //need to open a file stream 
            using (FileStream fs = new FileStream(requiredPath + "\\Source_Docs\\objects.pdf",
                                                             FileMode.Open, FileAccess.Read, FileShare.Read))
            {
                using (IacDocument pdfDoc = new IacDocument(null))
                {
                    try
                    {
                        pdfDoc.Open(fs, "");

                        //Declare ArrayList and fill it with all of the objects in the 
                        //current PDF document
                        ArrayList arList = (ArrayList)pdfDoc.GetPage(1).AttributeByName("Objects").Value;

                        //temp counter
                        int intCounter = 1;

                        foreach (IacObject obj in arList)
                        {
                            //you can access all properties of each object
                            IacAttribute attr = obj.Attribute("ObjectType");

                            //Check if it an text objects
                            if ((int)attr.Value == (int)IacObjectType.acObjectTypeText)
                            {
                                //change the backcolor
                                obj.Attribute("BackColor").Value = 192;

                                obj.Attribute("Text").Value = "Object: " + intCounter;
                                obj.Attribute("TextFont").Value = "Arial, 16, 700, 0, 0";
                                obj.Attribute("TextColor").Value = 0xFF8811;
                                intCounter++;
                            }
                        }

                        //Save PDF File
                        //save doc to new file
                        using (FileStream fs2 = new FileStream(requiredPath + "\\Resulting_Docs\\AddText_resulting.pdf",
                             FileMode.Create,
                             FileAccess.Write,
                             FileShare.Read))
                        {
                            pdfDoc.Save(fs2, IacFileSaveOption.acFileSaveView);
                            fs2.Close();
                        }

                    }
                    catch (Exception ev)
                    {
                        MessageBox.Show(ev.Message);
                    }

                    //end and cleanup
                    //this should only be done once
                    acPDFCreatorLib.Terminate();
                    _listBox1.Items.Add("AddText_resulting.pdf..........created");
                }
            }
        }




        /// <summary>
        /// The Append method can be used to append or concatenate a PDF file to the current document
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnAppendDocs_Click(object sender, EventArgs e)
        {
            //initailize library
            //This should be done once
            acPDFCreatorLib.Initialize();

            //set license key 
            acPDFCreatorLib.SetLicenseKey(StrLicenseTo, StrActivationCode);

            // Open the PDF document file.
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    System.Reflection.Assembly.GetExecutingAssembly().Location))));

            // Open the PDF document file.
            string strFilePathAndNameFileOne = requiredPath + "\\Source_Docs\\text.pdf";
            string strFilePathAndNameFileTwo = requiredPath + "\\Source_Docs\\logo.pdf";


            // Open the first PDF document from file
            using (FileStream file1 = new FileStream(strFilePathAndNameFileOne, FileMode.Open, FileAccess.Read))
            {
                IacDocument pdFdoc1 = new IacDocument(null);
                pdFdoc1.Open(file1, "");

                // Open the second PDF document from file
                FileStream file2 = new FileStream(strFilePathAndNameFileTwo, FileMode.Open, FileAccess.Read);
                IacDocument pdFdoc2 = new IacDocument(null);
                pdFdoc2.Open(file2, "");

                //append the two documents
                pdFdoc1.Append(pdFdoc2);
                file1.Close();

                //Option #1
                //reopen file stream and save
                //System.IO.FileStream filex = new System.IO.FileStream(strFilePathAndNameFileOne, FileMode.Open, FileAccess.ReadWrite);
                //PDFdoc1.Save(filex, IacFileSaveOption.acFileSaveView);


                //Option #2
                //Open the PDF document file.
                ////save doc to new file
                ////save the result to a third file
                FileStream file3 = new FileStream(requiredPath + "\\Resulting_Docs\\AppendDocs_resulting.pdf", FileMode.Create, FileAccess.Write);
                pdFdoc1.Save(file3);
            }
            _listBox1.Items.Add("AppendDocs_resulting.pdf .......... created");
        }




        /// <summary>
        /// The Merge method merges the contents of the current document into a specified PDF file.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnMerge_Click(object sender, EventArgs e)
        {

            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    System.Reflection.Assembly.GetExecutingAssembly().Location))));

            // Open the PDF document file.
            string strFilePathAndNameFileOne = requiredPath + "\\Source_Docs\\text.pdf";
            string strFilePathAndNameFileTwo = requiredPath + "\\Source_Docs\\logo.pdf";

            // Open the first PDF document from file
            using (FileStream file1 = new FileStream(strFilePathAndNameFileOne, FileMode.Open, FileAccess.Read))
            {
                IacDocument pdfDoc1 = new IacDocument(null);
                pdfDoc1.Open(file1, "");


                // Open the second PDF document from file
                FileStream file2 = new FileStream(strFilePathAndNameFileTwo, FileMode.Open, FileAccess.Read);
                IacDocument pdfDoc2 = new IacDocument(null);
                pdfDoc2.Open(file2, "");


                // merge the two documents
                pdfDoc1.Merge(pdfDoc2, 1);

                //need to open a file stream to save new PDF document
                // save the result to a third file
                using (FileStream file3 = new FileStream(requiredPath + "\\Resulting_Docs\\Merge_resulting.pdf",
                                                                         FileMode.Create, FileAccess.Write))
                {
                    pdfDoc1.Save(file3);
                }

            }

            _listBox1.Items.Add("Merge_resulting.pdf .............. created");


        }



        /// <summary>
        /// The ExportToJPeg method is used to export a PDF document to multiple JPEG files. It is recommended to use this
        /// method together with the OptimizeDocument method
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnExportToJpeg_Click(object sender, EventArgs e)
        {
            //set license key 
            acPDFCreatorLib.SetLicenseKey(StrLicenseTo, StrActivationCode);

            // Open the PDF document file.
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    System.Reflection.Assembly.GetExecutingAssembly().Location))));
            try
            {
                //Open file-steam
                using (FileStream fs = new FileStream(requiredPath + "\\Source_Docs\\text.pdf",
                         FileMode.Open,
                         FileAccess.Read,
                         FileShare.Read))
                {

                    using (IacDocument pdfDoc = new IacDocument(null))
                    {
                        pdfDoc.Open(fs, "");

                        /*  'No optimization 0
                            'Line optimization (Recommended) 1
                            'Paragraph optimization 2
                        */
                        pdfDoc.OptimizeDocument(1);

                        // Resulting JPG file.
                        //export the PDF file to JPEG format with the resoluction=300 and compression level=5.
                        pdfDoc.ExportToJPeg(requiredPath + "\\Resulting_Docs\\ExportToJpeg_resulting.jpg", 300, 5);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
                _listBox1.Items.Add("ExportToJpeg_resulting.jpg ...... created");
       }



        /// <summary>
        /// This code snippet illustrates how to add a bookmark to an existing PDF document
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnBookmarks_Click(object sender, EventArgs e)
        {
            //set license key 
            acPDFCreatorLib.SetLicenseKey(StrLicenseTo, StrActivationCode);

            // Open the PDF document file.
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    System.Reflection.Assembly.GetExecutingAssembly().Location))));

            //need to open a file stream 
            using (FileStream fs = new FileStream(requiredPath + "\\Source_Docs\\tenpages.pdf",
                                                          FileMode.Open, FileAccess.Read, FileShare.Read))
            {

                using (IacDocument pdfDoc = new IacDocument(null))
                {

                    pdfDoc.Open(fs, "");
                    try
                    {
                        int bookmarkPageNumber = 1;
                        int bookmarkNumber = 1;
                        pdfDoc.CurrentPage = pdfDoc.GetPage(bookmarkPageNumber);

                        pdfDoc.RootBookmark.InsertChild(bookmarkNumber, "text", "");

                        /*********************************************************************/
                        // Save file.
                        using (FileStream fs2 = new FileStream(requiredPath + "\\Resulting_Docs\\Bookmarks_resulting.pdf",
                            FileMode.Create,
                            FileAccess.Write,
                            FileShare.Read))
                        {
                            pdfDoc.Save(fs2, IacFileSaveOption.acFileSaveView);
                        }

                    }
                    catch (Exception ev)
                    {
                        MessageBox.Show(ev.Message);
                    }

                }
            }
            _listBox1.Items.Add("Bookmarks_resulting.pdf ....... created");
        }



        /// <summary>
        /// This code snippet illustrates how to create a new PDF document
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnNewDoc_Click(object sender, EventArgs e)
        {
            //initailize library
            //This should be done once
            acPDFCreatorLib.Initialize();

            //set license key 
            acPDFCreatorLib.SetLicenseKey(StrLicenseTo, StrActivationCode);

            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                        Path.GetDirectoryName(
                                        System.Reflection.Assembly.GetExecutingAssembly().Location))));

            //need to create a document object
            using (IacDocument doc = new IacDocument(null))
            {

                IacPage page = doc.GetPage(1);


                //create object on Page 1
                using (IacObject pic = page.CreateObject(IacObjectType.acObjectTypePicture, "acPic"))
                {
                    //position picture and and properties
                    pic.AttributeByName("left").Value = 200;
                    pic.AttributeByName("Top").Value = 600;
                    pic.AttributeByName("Right").Value = 2000;
                    pic.AttributeByName("Bottom").Value = 800;
                    pic.AttributeByName("FileName").Value = requiredPath + "\\Source_Docs\\demo_logo.jpg";

                }

                // Open the PDF document file.
                //save doc to new file
                using (FileStream fs2 = new FileStream(requiredPath + "\\Resulting_Docs\\NewDoc_resulting.pdf",
                     FileMode.Create,
                     FileAccess.Write,
                     FileShare.Read))
                {
                    doc.Save(fs2, IacFileSaveOption.acFileSaveView);
                }                
            }
            //end and cleanup
            //this should only be done once
            acPDFCreatorLib.Terminate();

            _listBox1.Items.Add("NewDoc_resulting.pdf  .....   created");

        }




        /// <summary>
        /// The DigitalSignature method is used to add a digital signature to a PDF document. Prior to digitally signing a
        /// document, the users or developers should have on their systems a digital certificate that can be used to sign
        /// documents. A user who receives a document that is digitally signed can verify if the digital signature is valid and if the
        /// document has been tempered with.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnDigitalSignature_Click(object sender, EventArgs e)
        {
            //set license key 
            acPDFCreatorLib.SetLicenseKey(StrLicenseTo, StrActivationCode);


            // Open the PDF document file.
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                        Path.GetDirectoryName(
                                        System.Reflection.Assembly.GetExecutingAssembly().Location))));

            //need to open a file stream 
            using (FileStream fs = new FileStream(requiredPath + "\\Source_Docs\\text.pdf", FileMode.Open, FileAccess.Read, FileShare.Read))
            {
                using (IacDocument pdfDoc = new IacDocument(null))
                {
                    pdfDoc.Open(fs, "");
                    try
                    {
                        /*****************************************************************/
                        //FLAGS
                        /*====================
                        '0: Hidden Signature
                        '1: Signer Name
                        '2: Reason for signing
                        '4: Location
                        '8: Associated Image
                        '32: Date of signing
                        '64: Signature type
                        '255: Show All 
                        ====================*/

                        pdfDoc.DigitalSignature("John Smith",
                        "My Reason",
                        requiredPath + "\\Source_Docs\\sign.jpg",
                        "Montreal",
                        1, 0, 0, 2000, 2000, 255);

                        /*********************************************************************/
                        // Open the PDF document file.
                        //save doc to new file
                        using (FileStream fs2 = new FileStream(requiredPath + "\\Resulting_Docs\\DigitalSignature_resulting.pdf",
                           FileMode.Create,
                           FileAccess.Write,
                           FileShare.Read))
                        {
                            pdfDoc.Save(fs2, IacFileSaveOption.acFileSaveView);
                        }
                    }
                    catch (Exception ev)
                    {
                        MessageBox.Show(ev.Message);
                    }
                }
        }
            _listBox1.Items.Add("DigitalSignature_resulting.pdf ...... created");
        }





        /// <summary>
        /// The StartPrint method starts printing the document to a specified printer. This method is used to start the printing
        /// process and takes the same parameters as the Print method.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnPrint_Click(object sender, EventArgs e)
        {

            //initailize library
            //This should be done once
            acPDFCreatorLib.Initialize();

            //set license key 
            acPDFCreatorLib.SetLicenseKey(StrLicenseTo, StrActivationCode);

            // Open the PDF document file.
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                        Path.GetDirectoryName(
                                        System.Reflection.Assembly.GetExecutingAssembly().Location))));

            //need to open a file stream 
            using (FileStream fs = new FileStream(requiredPath + "\\Source_Docs\\CreateTextObject.pdf", FileMode.Open, FileAccess.Read, FileShare.Read))
            {

                //need to create a document object
                using (IacDocument doc = new IacDocument(null))
                {
                    try
                    {
                        //Open the document
                        doc.Open(fs, "");

                        //Start printing document
                        //If no printer name is specified, the document is printed to the default printer.
                        doc.StartPrint("HP LaserJet P2035n", false);

                        //Print Page by Page
                        for (int pageIndex = 1; pageIndex <= doc.PageCount; pageIndex++)
                        {
                            doc.CurrentPage = doc.GetPage(pageIndex);
                            doc.PrintPage(doc.GetPage(pageIndex));
                        }

                        fs.Close();
                        //Stop printing
                        doc.EndPrint();

                    }
                    catch (Exception ev)
                    {
                        MessageBox.Show(ev.Message);
                    }


                }

                //end and cleanup
                //this should only be done once when your app terminates
                acPDFCreatorLib.Terminate();
            }
        }



        /// <summary>
        /// The Print method is used to print the document to a specified printer.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void cmdPrintDoc_Click(object sender, EventArgs e)
        {
            //initailize library
            //This should be done once
            acPDFCreatorLib.Initialize();

            //set license key 
            acPDFCreatorLib.SetLicenseKey(StrLicenseTo, StrActivationCode);


            // Open the PDF document file.
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                        Path.GetDirectoryName(
                                        System.Reflection.Assembly.GetExecutingAssembly().Location))));

            //need to open a file stream 
            using (FileStream fs = new FileStream(requiredPath + "\\Source_Docs\\CreateTextObject.pdf",
                                                                FileMode.Open,
                                                                FileAccess.Read,
                                                                FileShare.Read))
            {

                //need to create a document object
                using (IacDocument doc = new IacDocument(null))
                {
                    try
                    {
                        doc.Open(fs, "");

                        //Parameters
                        //      PrinterName
                        //If no printer name is specified, the document is printed to the default printer.
                        //      Prompt
                        //If this parameter is set to True, the user is prompted with the printer selection dialog box.

                        //Check if it password protected
                        if (doc.Protected == 1)
                        {
                            //check if print is enabled
                            if (IacCommandToolStatus.acCommandToolStatusEnabled == doc.UpdateCommandTool(IacCommandTool.acCommandToolPrint))
                            {
                                MessageBox.Show(@"doc encypted and printing disabled");
                            }
                            else
                            {
                                doc.Print("", false);
                            }
                        }
                    }
                    catch (Exception ev)
                    {
                        MessageBox.Show(ev.Message);
                    }
                }
                //end and cleanup
                //this should only be done once when your app terminates
                acPDFCreatorLib.Terminate();
            }
        }



        /// <summary>
        /// The GetObjectXY function returns a pointer to the object located at (X, Y) on the current page.
        /// X position in twips
        /// Y position in twips
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void cmdGetObjectXY_Click(object sender, EventArgs e)
        {

            //set license key 
            acPDFCreatorLib.SetLicenseKey(StrLicenseTo, StrActivationCode);

            // Open the PDF document file.
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                        Path.GetDirectoryName(
                                        System.Reflection.Assembly.GetExecutingAssembly().Location))));

            //need to open a file stream 
            using (FileStream fs = new FileStream(requiredPath + "\\Source_Docs\\objects.pdf", FileMode.Open, FileAccess.Read, FileShare.Read))
            {

                //need to create a document object
                using (IacDocument doc = new IacDocument(null))
                {
                    //open doc object with filestream
                    doc.Open(fs, "");

                    try
                    {
                        //Get object my its XP position
                        //1440 Twips/Inch
                        //25.4 MM/Inch
                        //56.7 Twips/MM 
                        using (IacObject oText = doc.GetPage(1).ObjectByXY(1590, 1700))
                        {
                            //Write value to Listbox
                            _listBox1.Items.Clear();
                            _listBox1.Items.Add("Found this:  " + oText.Attribute("Text").Value);
                        }
                    }
                    catch (Exception ex)
                    {
                        MessageBox.Show(ex.Message);
                    }
                }
               //end and cleanup
                //this should only be done once
                acPDFCreatorLib.Terminate();
            }
        }



        /// <summary>
        /// This code snippet illustrates how to add an acObjectTypeText object to a PDF document
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnCreateTextObject_Click(object sender, EventArgs e)
        {
            //initailize library
            //This should be done once
            acPDFCreatorLib.Initialize();

            //set license key 
            acPDFCreatorLib.SetLicenseKey(StrLicenseTo, StrActivationCode);

            // Open the PDF document file.
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                        Path.GetDirectoryName(
                                        System.Reflection.Assembly.GetExecutingAssembly().Location))));

            //need to open a file stream 
            using (FileStream fs = new FileStream(requiredPath + "\\Source_Docs\\CreateTextObject.pdf", FileMode.Open, FileAccess.Read, FileShare.Read))
            {
                //need to create a document object
                using (IacDocument pdfDoc = new IacDocument(null))
                {
                    pdfDoc.Open(fs, "");

                    //put PDF Creator component in design mode
                    pdfDoc.ReportState = IacReportState.acReportStateDesign;

                    //create an acText object on Page 1
                    using (IacObject oText = pdfDoc.GetPage(1).CreateObject(IacObjectType.acObjectTypeText, "acText"))
                    {
                        pdfDoc.CurrentPage = pdfDoc.GetPage(1);

                        oText.AttributeByName("left").Value = 1500;
                        oText.AttributeByName("Top").Value = 1000;
                        oText.AttributeByName("Right").Value = 8000;
                        oText.AttributeByName("Bottom").Value = 500;
                        oText.AttributeByName("TextAngle").Value = 900;
                        oText.AttributeByName("Text").Value = "Hello World";
                        oText.AttributeByName("TextFont").Value = "Arial, 18, 700, 0, 0";
                        oText.AttributeByName("TextColor").Value = 0xFAEBD7;
                    }

                    //need to open a file stream to save new PDF document
                    //save doc to new file
                    using (FileStream fs2 = new FileStream(requiredPath + "\\Resulting_Docs\\CreateTextObject_resulting.pdf",
                          FileMode.Create,
                          FileAccess.Write,
                          FileShare.Read))
                    {
                        pdfDoc.Save(fs2, IacFileSaveOption.acFileSaveView);
                        fs2.Close();
                    }
                }
                //end and cleanup
                //this should only be done once
                //when application ends
                acPDFCreatorLib.Terminate();
                _listBox1.Items.Add("CreateTextObject_resulting.pdf.... created");
            }
        }


        /// <summary>
        /// The ExportToXPS method is used to export a PDF document to XPS format.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnExportToXps_Click(object sender, EventArgs e)
        {
                 //initailize library
                //This should be done once
                acPDFCreatorLib.Initialize();

                //set license key 
                acPDFCreatorLib.SetLicenseKey(StrLicenseTo, StrActivationCode);

                // Open the PDF document file.
                //get startup path for temp working files
                var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                            Path.GetDirectoryName(
                                            System.Reflection.Assembly.GetExecutingAssembly().Location))));

                //Open file-steam
                using (FileStream fs = new FileStream(requiredPath + "\\Source_Docs\\text.pdf",
                     FileMode.Open,
                     FileAccess.Read,
                     FileShare.Read))
                {

                    try
                    {
                        using (IacDocument pdfDoc = new IacDocument(null))
                        {
                            pdfDoc.Open(fs, "");
                            /*  'No optimization 0
                            'Line optimization (Recommended) 1
                            'Paragraph optimization 2
                            */
                            pdfDoc.OptimizeDocument(0);

                            // Resulting XPS file.
                            //export the PDF file to Xps
                            pdfDoc.ExportToXPS(requiredPath + "\\Resulting_Docs\\ExportToXps_resulting.xps",
                                IacXPSExportOptions.acXPSExportOptionsNone);
                            fs.Close();
                            pdfDoc.Dispose();
                        }
                    }
                    catch (Exception ex)
                    {
                        MessageBox.Show(ex.Message);
                    }
                }
            acPDFCreatorLib.Terminate();
            _listBox1.Items.Add("ExportToXps_resulting.xps ...... created");
        }

  


        /// <summary>
        /// This code snippet illustrates how to enumerate through the contents of a PDF document 
        /// and change the text values of all acField objects
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnLoopObjects_Click(object sender, EventArgs e)
        { 
            //initailize library
            //This should be done once
            acPDFCreatorLib.Initialize();

            //set license key This is needed only with licensed version
            acPDFCreatorLib.SetLicenseKey(StrLicenseTo, StrActivationCode);

            // Open the PDF document file.
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                        Path.GetDirectoryName(
                                        System.Reflection.Assembly.GetExecutingAssembly().Location))));
            try
            {
                //need to create a document object
                using (IacDocument doc = new IacDocument(null))
                {
                    try
                    {
                        using (FileStream fs = new FileStream(requiredPath + "\\Source_Docs\\CreateTextObject.pdf",
                                                            FileMode.Open, FileAccess.Read, FileShare.Read))
                        {
                            doc.Open(fs, "");

                            for (int i = 1; i <= doc.PageCount; i++)
                            {
                                //set current page:
                                doc.CurrentPage = doc.GetPage(i);
                                //Declare ArrayList and fill it with all of the objects in the 
                                ArrayList arList = (ArrayList)doc.GetPage(i).Attribute("Objects").Value;

                                //temp counter
                                int intCounter = 1;

                                MessageBox.Show(arList.Count.ToString());
                                foreach (IacObject obj in arList)
                                {
                                    //you can access all properties of each object
                                    var attr = obj.Attribute("ObjectType");

                                    //You have access to object
                                    //here you are checking if it is a field object
                                    if ((int) attr.Value == (int) IacObjectType.acObjectTypeField)
                                    {
                                        obj.Attribute("Value").Value = "Object " + intCounter;
                                        obj.Attribute("TextFont").Value = "Arial, 16, 700, 0, 0";
                                        obj.Attribute("TextColor").Value = 0xFF8811;
                                        //MessageBox.Show(obj.Attribute("Text").Value);
                                    }

                                    //MessageBox.Show(intCounter.ToString());
                                    intCounter++;
                                }
                            }

                            //need to open a file stream to save new PDF document
                            //save doc to new file
                            using (FileStream fs2 = new FileStream(requiredPath + "\\Resulting_Docs\\LoopObjects_resulting.pdf",
                                  FileMode.Create,
                                  FileAccess.Write,
                                  FileShare.Read))
                            {
                                doc.Save(fs2, IacFileSaveOption.acFileSaveView);
                                fs2.Close();
                            }
                        }
                    }
                    catch (Exception ev)
                    {
                        MessageBox.Show(ev.Message);
                    }

                  }
                 
            }            
            catch (Exception ex)
            {
                 MessageBox.Show(ex.Message);
            }
            //end and cleanup
            //this should only be done once when your app terminates
            acPDFCreatorLib.Terminate();
            _listBox1.Items.Add("LoopObjects_resulting.pdf ..... created");
        }




        /// <summary>
        /// The ReachText function reaches a text object having a specified text and font attributes. This function searches the
        ///document for the first object containing the specified text and makes that object visible.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnSearch_Click(object sender, EventArgs e)
        {
            //initailize library
            //This should be done once
            acPDFCreatorLib.Initialize();          

            //set license key 
            acPDFCreatorLib.SetLicenseKey(StrLicenseTo, StrActivationCode);

            // Open the PDF document file.
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                        Path.GetDirectoryName(
                                        System.Reflection.Assembly.GetExecutingAssembly().Location))));

            //need to open a file stream 
            using (FileStream fs = new FileStream(requiredPath + "\\Source_Docs\\objects.pdf", FileMode.Open, FileAccess.Read, FileShare.Read))
            {
                //need to create a document object
                using (IacDocument doc = new IacDocument(null))
                {
                    //open doc object with filestream
                    doc.Open(fs, "");

                    /*  'No optimization 0
                        'Line optimization (Recommended) 1
                        'Paragraph optimization 2
                    */
                    doc.OptimizeDocument(1);

                    try
                    {
                        // Search for text		
                        string strFindText = doc.ReachText(IacReachTextOption.acReachTextOptionStartNoCase, "1", "", 0, false, false);
                        doc.ReportState = IacReportState.acReportStateDesign;

                        // Check if text is found
                        if (strFindText != "")
                        {
                            // Replace it with a new text
                            IacObject acObject = doc.ObjectByName(strFindText);
                            if (acObject != null)
                            {
                                //Found object now change the value
                                acObject.AttributeByName("Text").Value = "Hello";
                            }
                        }

                        //need to open a file stream to save new PDF document
                        //save doc to new file
                        using (FileStream fs2 = new FileStream(requiredPath + "\\Resulting_Docs\\Search_resulting.pdf",
                             FileMode.Create,
                             FileAccess.Write,
                             FileShare.Read))
                        {
                            doc.Save(fs2, IacFileSaveOption.acFileSaveView);
                            fs2.Close();
                        }
                    }
                    catch (Exception ex)
                    {
                        MessageBox.Show(ex.Message);
                    }
                    _listBox1.Items.Add("Search_resulting.pdf ........ created");
                }
            }
            //end and cleanup
            //this should only be done once
            acPDFCreatorLib.Terminate();
        }




        /// <summary>
        /// This code snippet illustrates how add custom MetaData to a PDF document
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnAddMetaData_Click(object sender, EventArgs e)
        {
            //set license key 
            acPDFCreatorLib.SetLicenseKey(StrLicenseTo, StrActivationCode);

            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                            Path.GetDirectoryName(
                            System.Reflection.Assembly.GetExecutingAssembly().Location))));

            //need to open a file stream 
            using (FileStream fs = new FileStream(requiredPath + "\\Source_Docs\\text.pdf", FileMode.Open, FileAccess.Read, FileShare.Read))
            {
                using (IacDocument pdfDoc = new IacDocument(null))
                {
                    try
                    {
                        pdfDoc.Open(fs, "");

                        //Example: 1 add metadata

                        //0: No metadata stream
                        //1: Basic XMP metadata  generated by PDF Creator
                        //2: Custom metadata stream generated by the calling application
                        //3: PDF/A compatible matadata stream (Acrobat 8)
                        //4:PDF/A compatible
                        IacAttribute attrMetadata = pdfDoc.AttributeByName("Metadata");
                        attrMetadata.Value = 1;

                        //need to open a file stream to save new PDF document
                        //save doc to new file
                        using (FileStream fs2 = new FileStream(requiredPath + "\\Resulting_Docs\\AddMetaData_resulting.pdf",
                            FileMode.Create,
                            FileAccess.Write,
                            FileShare.Read))
                        {
                            pdfDoc.Save(fs2, IacFileSaveOption.acFileSaveView);
                            fs2.Close();
                        }
                    }
                    catch (Exception ev)
                    {
                        MessageBox.Show(ev.Message);
                    }
                }
            }
            _listBox1.Items.Add("AddMetaData_resulting.pdf ......... created");
        }




        /// <summary>
        /// This code snippet illustrates how add custom MetaData to a PDF document
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnMetaData2_Click(object sender, EventArgs e)
        {

            //set license key 
            acPDFCreatorLib.SetLicenseKey(StrLicenseTo, StrActivationCode);

            //get startup path for temp working files.
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                            Path.GetDirectoryName(
                            System.Reflection.Assembly.GetExecutingAssembly().Location))));

            //need to open a file stream 
            using (FileStream fs = new FileStream(requiredPath + "\\Source_Docs\\text.pdf",
                                                        FileMode.Open, FileAccess.Read, FileShare.Read))
            {
                using (IacDocument pdfDoc = new IacDocument(null))
                    try
                    {
                        pdfDoc.Open(fs, "");

                        //Example: 2 add custom XML metadata
                        //0: No metadata stream
                        //1: Basic XMP metadata  generated by PDF Creator
                        //2: Custom metadata stream generated by the calling application
                        //3: PDF/A compatible matadata stream (Acrobat 8)
                        //4:PDF/A compatible

                        StringBuilder sb = new StringBuilder();
                        sb.Append("<rdf:Description>"); //starting tag
                        sb.Append("<myXLLtag>Amyuni XLM Tag</myXLLtag>");
                        sb.Append("</rdf:Description>"); //ending tag 
                        IacAttribute attrMetadata = pdfDoc.AttributeByName("Metadata");
                        attrMetadata.Value = 1;

                        //Here we are adding custom XML data
                        //This is not in our documentation
                        IacAttribute attrExtraXmpMetadata = pdfDoc.AttributeByName("ExtraXMPMetadata");
                        attrExtraXmpMetadata.Value = sb.ToString();

                        /*********************************************************************/
                        //need to open a file stream to save new PDF document

                        //save doc to new file
                        using (FileStream fs2 = new FileStream(
                            requiredPath + "\\Resulting_Docs\\MetaData2_resulting.pdf",
                            FileMode.Create,
                            FileAccess.Write,
                            FileShare.Read))
                        {
                            pdfDoc.Save(fs2, IacFileSaveOption.acFileSaveView);
                            fs2.Close();
                        }
                    }
                    catch (Exception ev)
                    {
                        MessageBox.Show(ev.Message);
                    }
            }
            _listBox1.Items.Add("MetaData2_resulting.pdf ......... created");
        }



        /// <summary>
        /// This code snippet illustrates how read custom MetaData to a PDF document
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnMetaData3_Click(object sender, EventArgs e)
        {

            //set license key 
            acPDFCreatorLib.SetLicenseKey(StrLicenseTo, StrActivationCode);

            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                            Path.GetDirectoryName(
                            System.Reflection.Assembly.GetExecutingAssembly().Location))));

            //need to open a file stream 
            using (FileStream fs = new FileStream(requiredPath + "\\Resulting_Docs\\MetaData2_resulting.pdf",
                                                                  FileMode.Open, FileAccess.Read, FileShare.Read))
            {
                using (IacDocument pdfDoc = new IacDocument(null))
                {
                    try
                    {
                        pdfDoc.Open(fs, "");

                        //This returns the Metadata embeded in the document
                        //This will also return an metadata added by ExtraXMPMetadata attribute
                        MessageBox.Show(pdfDoc.AttributeByName("MetadataStream").Value.ToString());

                        //This returns metadata added by ExtraXMPMetadata attribute only
                        MessageBox.Show(pdfDoc.AttributeByName("ExtraXMPMetadata").Value.ToString());
                    }
                    catch (Exception ev)
                    {
                        MessageBox.Show(ev.Message);
                    }
                }
            }
        }




        /// <summary>
        /// The Encrypt128 method secures the PDF document with 128-bit encryption and prevents it from unauthorized
        /// access. Two passwords, the owner password and user password, are associated to
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnEncryption_Click(object sender, EventArgs e)
        {
            //Initialize library and set the license key

            acPDFCreatorLib.Initialize();
            acPDFCreatorLib.SetLicenseKey(StrLicenseTo, StrActivationCode);

            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                            Path.GetDirectoryName(
                            System.Reflection.Assembly.GetExecutingAssembly().Location))));

            IacDocument document = new IacDocument(null);
            FileStream file1 = new FileStream(requiredPath + "\\Source_Docs\\tenpages.pdf", FileMode.Open);
            FileStream file2 = new FileStream(requiredPath + "\\Resulting_Docs\\Encryption_resulting.pdf", FileMode.Create);

            /*
            No permission 0xFFFFFFC0
            Enable printing 0xFFFFFFC0 + 4
            Enable changing the document 0xFFFFFFC0 + 8
            Enable copying text and graphics 0xFFFFFFC0 + 16
            Enable adding and changing notes 0xFFFFFFC0 + 32 
            */

            //No permissions for the user
            UInt32 permissions = 0xFFFFFFC0;

            //create and save Encrypted file 
            document.Open(file1, "");

            //document.Encrypt("owner", "user", permissions);
            document.Encrypt128("aaaaaa", "bbbbbb", permissions);

            document.Save(file2, IacFileSaveOption.acFileSaveView);

            _listBox1.Items.Add("Encryption_resulting.pdf  ......   created");
        }




        /// <summary>
        /// The ExportToTiff method is used to export a PDF document to a single TIFF file. It is recommended to use this
        ///  method together with the OptimizeDocument method
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnTiff_Click(object sender, EventArgs e)
        {
            //Initialize PDF Creator Lib
            acPDFCreatorLib.Initialize();
            acPDFCreatorLib.SetLicenseKey(StrLicenseTo , StrActivationCode);

            uint tiffFormat = 10;
            uint tiffResolution = 100;

            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                            Path.GetDirectoryName(
                            System.Reflection.Assembly.GetExecutingAssembly().Location))));

            using (FileStream fs = new FileStream(requiredPath + "\\Source_Docs\\text.pdf", FileMode.Open))
            {
                IacDocument document = new IacDocument(null);
                document.OpenEx(fs, "");

                /*  'No optimization 0
                    'Line optimization (Recommended) 1
                    'Paragraph optimization 2
                */
                document.OptimizeDocument(1);

                // Resulting TIFF file.
                //export the PDF file to JPEG format with the resoluction=300 and compression level=5.
                document.ExportToTiff(requiredPath + "\\Resulting_Docs\\btnTiff_resulting.tiff", tiffResolution, tiffFormat);

                document.Dispose();
                fs.Close();
            }
            _listBox1.Items.Add("btnTiff_resulting.tiff ....... created");
        }


        /// <summary>
        /// This code snippet illustrates how to save an XPS document as a PDF document
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnXps2PDF_Click(object sender, EventArgs e)
        {
            acPDFCreatorLib.Initialize();
            acPDFCreatorLib.SetLicenseKey(StrLicenseTo, StrActivationCode);
           
            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                            Path.GetDirectoryName(
                            System.Reflection.Assembly.GetExecutingAssembly().Location))));

            using (FileStream file = new FileStream(requiredPath + "\\Source_Docs\\webpage.xps", FileMode.Open,
                                                       FileAccess.Read, FileShare.Read))
            {
                using (IacDocument document = new IacDocument(null))
                {
                    // Open the XPS document file.
                    document.OpenEx(file, "");

                    //delete file if it already exusts
                    //File.Delete(requiredPath + "\\Resulting_Docs\\Xps2PDF_resulting.pdf");

                    // Resulting XPS file.
                    using (FileStream output = new FileStream(requiredPath + "\\Resulting_Docs\\Xps2PDF_resulting.pdf", FileMode.Create,
                                                        FileAccess.Write, FileShare.Read))
                    { 
                        try
                        {
                            document.Save(output, IacFileSaveOption.acFileSaveView);
                        }
                        catch (Exception ex)
                        {
                            MessageBox.Show(ex.Message);
                        }
                        output.Close();
                    }

                    file.Close();
                }
            }
            acPDFCreatorLib.Terminate();
            _listBox1.Items.Add("Xps2PDF_resulting.pdf ...... created");

        }



        /// <summary>
        /// The ExportToHTML method is used to export a PDF document to HTML format. It is recommended to use this method
        /// together with the OptimizeDocument method
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnPDFtoHTML_Click(object sender, EventArgs e)
        {
                acPDFCreatorLib.Initialize();
                //set license key 
                //2 page limit on export
                acPDFCreatorLib.SetLicenseKey(StrLicenseTo, StrActivationCode);

                //get startup path for temp working files
                var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                Path.GetDirectoryName(
                                System.Reflection.Assembly.GetExecutingAssembly().Location))));

                //Open file-steam
                using (FileStream fs = new FileStream(requiredPath + "\\Source_Docs\\text.pdf",
                      FileMode.Open,
                      FileAccess.Read,
                      FileShare.Read))
                {
                try
                {
                    using (IacDocument pdfDoc = new IacDocument(null))
                    {
                        pdfDoc.Open(fs, "");

                        /* '//////////////////////////////////////////////////////////////////
                        'Optimization level to apply to PDF document before exporting to Excel.
                        'No optimization 0
                        'Line optimization (Recommended) 1
                        'Paragraph optimization 2
                        ' optimize document to line level before exporting
                        */
                        pdfDoc.OptimizeDocument(1);

                        /*
                        '//////////////////////////////////////////////////////////////
                        'Options
                        ' Use Layers: Multiple pages in a single HTML file using layers 0001
                        ' Single HTML: All pages in a single HTML file 0002
                        ' Multiple HTML files: Each page in a separate HTML file 0003
                        ' VectorGraphics
                        */
                        //export the PDF file to HTML format
                        pdfDoc.ExportToHTML(requiredPath + "\\Resulting_Docs\\PDFtoHTML_resulting.htm", IacHtmlExportOption.acHtmlExportOptionSinglePage);
                        fs.Close();
                    }
                }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }
            _listBox1.Items.Add("PDFtoHTML_resulting.htm ....... created");
        }





        /// <summary>
        /// The GetObjectsInRectangle method gets all the objects that are in the specified rectangle. 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnGetObjRect_Click(object sender, EventArgs e)
        {
            //initailize library
            //This should be done once
            acPDFCreatorLib.Initialize();

            //set license key This is needed only with licensed version
            acPDFCreatorLib.SetLicenseKey(StrLicenseTo, StrActivationCode);

            //get startup path for temp working files
            var requiredPath = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                            Path.GetDirectoryName(
                            System.Reflection.Assembly.GetExecutingAssembly().Location))));
            try
            {
                //need to create a document object
                using (IacDocument doc = new IacDocument(null))
                {
                    try
                    {
                        //need to open a file stream 
                        using (FileStream fs = new FileStream(requiredPath + "\\Source_Docs\\CreateTextObject.pdf",
                                                            mode: FileMode.Open, access: FileAccess.Read, share: FileShare.Read))
                        {
                            doc.Open(fs, "");
                            doc.OptimizeDocument(1);

                            //Gets an array of objects in a rectangle
                            object[] objects = (object[])doc.GetObjectsInRectangle(100, 100, 10000, 10000,
                                                      IacGetRectObjectsConstants.acGetRectObjectsInMainDocument);
                            //found objects
                            if (objects.Length == 0) return;
                            foreach (var t in objects)
                            {
                                var acObject = (IacObject) t;
                                if (acObject != null)
                                {
                                   // types of objects found  
                                    MessageBox.Show(acObject.Attribute("ObjectType").Value.ToString());
                                }
                            }
                        }
                    }
                    catch (Exception ev)
                    {
                        MessageBox.Show(ev.Message);
                    }
                }
            }
            catch (Exception ev)
            {
                MessageBox.Show(ev.Message);
            }
         }
    }
}
